﻿QIPortalAPI.uploadUppy = {

};

QIPortalAPI.FileUpload = function (id, MaxFileSize, MaxTotalFileSize, MaxNumberOfFiles, FileTypes, language, f_Width, f_Height, JsonLanguageString, StyleClass) //{_width}','{_height}','{_color}
{
    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://releases.transloadit.com/uppy/v3.14.0/uppy.min.css';
    document.head.appendChild(link);

    let Height = parseStringOrNumber(f_Height);
    let Width = parseStringOrNumber(f_Width);

    if (FileTypes == "images" || FileTypes == "image") {
        FileTypes = "image/*";
    }

    let FileTypesArray = FileTypes.split(',');
    if (FileTypes == null || FileTypes == "" || FileTypes == "*") {
        FileTypesArray = null;
    }

    //get submit button and save form submit action to oldhandler t
    const submitButton = document.getElementById(QIHelpDesk.submitButtonID);
    QIPortalAPI.uploadUppy.oldhandler = submitButton.onclick;
    QIPortalAPI.uploadUppy.oldHref = submitButton.getAttribute('href');

    const languageStrings = JSON.parse(JsonLanguageString);

    updateStrings(languageStrings);

    function updateStrings(languageStrings) {
        for (const keyword in languageStrings) {
            translatelanguage.strings[keyword] = languageStrings[keyword];
        }
    }

    // https://stackoverflow.com/questions/105034/how-do-i-create-a-guid-uuid
    // if isSecureContext is not set, Math.random is enough for our file name...
    function generateGUID() {
        return window.isSecureContext
            ? window.crypto.randomUUID() + '_'
            : 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx_'.replace(/[xy]/g, function (c) {
                const r = (Math.random() * 16) | 0,
                    v = c === 'x' ? r : (r & 0x3) | 0x8;
                return v.toString(16);
            });
    }

    function parseStringOrNumber(input) {

        return input.endsWith('%') ? input : parseInt(input);
    }

    submitButton.onclick = (e) => QIPortalAPI.StartUppyUpload();
    submitButton.removeAttribute('href');

    Promise.all([
        import('https://releases.transloadit.com/uppy/v3.14.0/uppy.min.mjs')
    ])
        .then((modules) => {
            const uppyModule = modules[0];

            const Div = document.querySelector('[uploadId="' + id + '"]');
            Div.classList.add(StyleClass);

            const uppy = new uppyModule.Uppy({
                debug: true,
                autoProceed: false,

                restrictions: {
                    maxFileSize: parseInt(MaxFileSize), //int Bytes               
                    maxTotalFileSize: parseInt(MaxTotalFileSize), //int Bytes
                    maxNumberOfFiles: parseInt(MaxNumberOfFiles), //int

                    allowedFileTypes: FileTypesArray,
                    //.jpg or image/*
                },
                locale: (language == "en") ? null : translatelanguage,
                // Modify the filename when file added
                onBeforeFileAdded: (file, files) => {
                    const modifiedName = generateGUID() + file.name.normalize('NFC');
                    uppy.setMeta(file.name, { newfilename: modifiedName });
                    Object.defineProperty(file.data, 'name', {
                        writable: true,
                        value: modifiedName
                    });

                    return Object.assign(file, { name: modifiedName });
                }

            })

                //dashboard
                .use(uppyModule.Dashboard, {
                    target: "#" + Div.id,
                    inline: true,

                    width: Width,
                    height: Height,

                    proudlyDisplayPoweredByUppy: false,

                    hideUploadButton: true

                }).use(uppyModule.Tus, {
                    endpoint: QIPortalAPI.appPath + '/FileUpload/Tus',
                    uploadUrl: QIPortalAPI.appPath + '/FileUpload/Tus',
                    allowedMetaFields: null,
                    chunkSize: 5 * 1024 * 1024, // 5MB
                    limit: 2,
                    async onBeforeRequest (req, file) {
                      req.setHeader('X-Filename', file.name);
                    }
                })
                .on('upload-success', (file, response) => {
                })

                .on('upload-error', (file, error, response) => {
                    if (response.status === 423) { // if status is 423, Locked
                        setTimeout(() => {
                            uppy.retryUpload(file.id) // retry uploading
                        }, 5000) // 5 seconds delay before retrying
                    }
                    console.error('Error uploading file:', file.name);
                    console.error('Error message:', error);
                })
                .on('complete', (result) => {
                    const hiddenInput = document.getElementById("qiTempNames");

                    let tempFilesString = '';
                    result.successful.forEach((item) => {
                        tempFilesString += item.name.normalize('NFC') + '|';
                    });
                    hiddenInput.value = tempFilesString;

                    QIHelpDesk.enableInputs();
                    submitButton.onclick = QIPortalAPI.uploadUppy.oldhandler;
                    submitButton.setAttribute('href', QIPortalAPI.uploadUppy.oldHref);

                    setTimeout(function () {
                        submitButton.click();
                    }, 10);
                });
            function upload() {
                if ((typeof (Page_ClientValidate) == 'function' && !Page_ClientValidate() || (typeof (ValidatorOnSubmit) == 'function' && !ValidatorOnSubmit()))) {
                    QIPortalAPI.hideSplash();
                    QIHelpDesk.performValidation = QIHelpDesk.initPerformValidation;
                    return;
                };
                if (QIHelpDesk.onSubmit() === false)
                    return;
                if (typeof (ValidatorOnSubmit) == "function" && ValidatorOnSubmit() == false)
                    return;
                QIHelpDesk.disableInputs();
                uppy.upload({
                });
            }

            QIPortalAPI.StartUppyUpload = upload;
            //isInitialized = true;
        })
        .catch((error) => {
            // Handle any errors during module import
            console.error('Error importing modules:', error);
        });


}




